<?php
/* --------------------------------------------------------------
 PluginRegistryService.php 2020-03-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Plugins;

/**
 * Interface PluginRegistryService
 * @package Gambio\Core\Application\Plugins
 */
interface PluginRegistryService
{
    /**
     * Provides the plugins registry.
     *
     * The plugins registry is an one dimensional associative array containing information
     * about any class that implements the Gambio\Core\Application\Plugins\PluginInterface interface.
     *
     * Classes that implements this interface are interpreted as plugins entry point. They are responsible
     * to register all of the plugins functionality.
     *
     * The key of the returned array contains the absolute file path of the plugins entry point. The value
     * will be the full qualified class name. With that information, it is possible to load everything required
     * in the shops bootstrap process.
     *
     * @return array
     */
    public function get(): array;
    
    
    /**
     * Verifies the plugins registry to be present.
     * If this method returns false, the registry can be rebuild with ::rebuildPluginsRegistry().
     *
     * @return bool
     *
     * @see PluginRegistryService::get
     * @see PluginRegistryService::rebuild
     */
    public function exists(): bool;
    
    
    /**
     * Rebuilds the plugins registry.
     *
     * The function will scan the plugins directory for any php class implementing the
     * Gambio\Core\Application\Plugins\PluginInterface interface and collects all information needed to load them.
     * Afterwards, the existing registry will be replaced with a new one.
     *
     * @see PluginRegistryService::get
     */
    public function rebuild(): void;
    
    
    /**
     * Just deletes the current plugin registry cache file.
     */
    public function delete(): void;
}